<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <!-- Title -->
    <title>{{ config('app.name', 'Laravel') }} - Not Found</title>

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- Required Meta Tags Always Come First -->
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>

    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ asset('favicon.png') }}">

    <!-- App CSS -->
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
</head>

<body class="bg-img-hero-fixed gradient-half-primary-body-v1">
<!-- ========== HEADER ========== -->
<header id="header" class="u-header u-header--bg-transparent u-header--abs-top pt-3">
    <div class="u-header__section">
        <div id="logoAndNav" class="container">
            <!-- Nav -->
            <nav class="navbar navbar-expand u-header__navbar">
                <!-- Logo -->
                <a class="navbar-brand u-header__navbar-brand u-header__navbar-brand-center u-header__navbar-brand-text-white"
                   href="/" aria-label="PayMe">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                         width="36px"
                         height="36px" viewBox="0 0 36 36" xml:space="preserve" style="margin-bottom: 0;">
              <path fill="#FFFFFF"
                    d="M18,0h11.4C33,0,36,3,36,6.6c0,0,0,0,0,0V18c0,9.9-8.1,18-18,18l0,0C8.1,36,0,27.9,0,18l0,0C0,8.1,8.1,0,18,0z"/>
                        <path fill="#377DFF" d="M17,26.4c-2.1-0.1-4.1-0.5-6-1.3v-4.5c1.1,0.6,2.3,1,3.6,1.4c1.1,0.3,2.2,0.5,3.4,0.5c0.6,0,1.2-0.1,1.8-0.3
                                      c0.4-0.2,0.6-0.5,0.6-0.9c0-0.3-0.2-0.6-0.4-0.8c-0.4-0.3-0.9-0.5-1.3-0.7c-0.6-0.3-1.5-0.6-2.6-1c-1-0.3-2-0.8-2.9-1.4
                                      c-0.7-0.5-1.2-1.1-1.6-1.8c-0.4-0.8-0.5-1.6-0.5-2.5c-0.1-1.3,0.5-2.6,1.5-3.5C13.8,8.6,15.4,8,17,8V6h3v1.9c2,0.1,4,0.6,5.8,1.3
                                      l-1.7,3.9c-1.7-0.8-3.6-1.2-5.5-1.3c-0.6,0-1.1,0.1-1.6,0.3c-0.3,0.2-0.5,0.5-0.5,0.8c0,0.3,0.1,0.6,0.3,0.8
                                      c0.4,0.3,0.8,0.5,1.2,0.7c0.6,0.2,1.3,0.5,2.3,0.8c1.6,0.4,3.1,1.2,4.3,2.3c0.9,0.9,1.4,2.1,1.3,3.4c0.1,1.4-0.5,2.8-1.5,3.8
                                      c-1.3,1.1-2.8,1.7-4.5,1.8V29h-3L17,26.4z"/>
            </svg>
                    <span class="u-header__navbar-brand-text">PayMe</span>
                </a>
                <!-- End Logo -->
            </nav>
            <!-- End Nav -->
        </div>
    </div>
</header>
<!-- ========== END HEADER ========== -->

<!-- ========== MAIN ========== -->
<main id="content" role="main">
    <!-- Hero Section -->
    <div class="d-lg-flex">
        <div class="container d-lg-flex align-items-lg-center min-height-lg-100vh space-4">
            <div class="w-lg-60 w-xl-50">
                <!-- Title -->
                <div class="mb-5 =">
                    <h1 class="text-primary font-weight-normal text-white">
                        <span class="font-weight-semi-bold">Oops!</span> Page not found
                    </h1>
                    <p class="mb-0 text-white-70">It looks like page you're looking for could not be found.</p>
                </div>
                <!-- End Title -->

                <a class="btn btn-white btn-wide transition-3d-hover" href="/">Go Back</a>
            </div>
        </div>
    </div>
    <!-- End Hero Section -->
</main>
<!-- ========== END MAIN ========== -->

<!-- ========== FOOTER ========== -->
<footer class="position-md-absolute right-md-0 bottom-md-0 left-md-0">
    <div class="container">
        <div class="d-flex justify-content-between align-items-center space-1">
            <!-- Copyright -->
            <p class="small text-white-70 mb-0">&copy; {{ date('Y') }} <a class="link-white" href="/">{{ config('app.name', 'Laravel') }}</a> &mdash; All rights
                reserved.</p>
            <!-- End Copyright -->

        </div>
    </div>
</footer>
<!-- ========== END FOOTER ========== -->

<!-- JS Core -->
<script src="{{ asset('js/app.js') }}"></script>
<!-- JS -->
<script src="{{ asset('js/vendor.js') }}"></script>
</body>

</html>